<?php

class AopsZapierIntegration extends Aops {

	private static $options = array();

	// not needed yet
	//public static $apiKey = '';

	public function __construct() {
		self::$options = self::getOptions();
		// not needed yet
		//self::$apiKey = get_option(self::$prefix . 'zapier_api_key');

		/* Check Zapier API key when it`s entered */
		// not needed yet
		//add_action( 'admin_init', array( $this, 'checkZapierApiKey' ) );

		/* Add rewrite rules to create a Zapier endpoint  */
		//add_action( 'init', array( $this, 'registerRewriteRules' ) );

		if ( ! is_admin() && self::$options['zapier_webhook_url'] ) {
			add_action('template_redirect', array($this, 'processZapierRequest'));
		}

	}

	// not needed yet
	public function checkZapierApiKey() {
		if (isset($_POST['aops_cu_zapier_api_key'])) {
			$newApiKey = $_POST['aops_cu_zapier_api_key'];
			if ($newApiKey != '') {
				self::log("checkZapierApiKey: " . $newApiKey);

				$newZapierStatus = self::STATUS_OK;

				self::log("checkZapierApiKey newZapierStatus " . $newZapierStatus);
				// clear options cache
				wp_cache_delete ( 'alloptions', 'options' );
			}
			else{
				$newZapierStatus = self::STATUS_UNKNOWN;
			}

			// wordpress will use this later to save option into DB
			$_POST['aops_cu_zapier_status'] = $newZapierStatus;
		}
	}

	/**
	 * Register additional rewrite rule to create Zapier endpoint
	 */
	public static function registerRewriteRules() {
		$zapierSlug = 'cu_zapier';

		// from options-permalink.php :
		$permalink_structure = get_option( 'permalink_structure' );

		/**
		 * In a subdirectory configuration of multisite, the `/blog` prefix is used by
		 * default on the main site to avoid collisions with other sites created on that
		 * network. If the `permalink_structure` option has been changed to remove this
		 * base prefix, WordPress core can no longer account for the possible collision.
		 */

		if ( is_multisite() && ! is_subdomain_install() && is_main_site() && 0 === strpos( $permalink_structure, '/blog/' ) ) {
		   $blog_prefix = 'blog/';
		}
		else {
			$blog_prefix = '';
		}

		$rewrite = $blog_prefix . $zapierSlug . '/([^&]+)\.json?$';

		add_rewrite_tag( '%zapier_request%', '([^&]+)' );
		add_rewrite_rule( $rewrite, 'index.php?zapier_request=$matches[1]', 'top' );
		flush_rewrite_rules(false); // update permalink structure since we are adding new rewrite rule for Zapier endpoint

	}


	/**
	 * Fired by 'template_redirect' action
	 *
	 * checks if request made by Zapier
	 * if yes, processes this request and dies
	 */
	public function processZapierRequest( ) {
		global $wp_query;
		$zapierRequest = $wp_query->get( 'zapier_request' );

		if ( $zapierRequest ) {
			$this->respondToZapier($zapierRequest);
			die();
		}

		return $wp_query;
	}


	/**
	 *
	 */
	public function respondToZapier( $zapierRequest ) {
		switch ($zapierRequest) {
			case 'ping':
				$responseData = array(
					'time'	=> time(),
					'test'	=> $zapierRequest
				);
				break;
			case 'test':
				$responseData = array(
					'test'	=> time(),
					'test'	=> $zapierRequest
				);
				break;
			default:
				$responseData = array(
					'error'	=> 'unknown request action'
				);
				break;
		}


		wp_send_json( $responseData );
	}

	public static function processSubmission( $cuID, $email, $firstname ) {
		$meta = self::getMeta($cuID);
		$cuTitle = $meta['title'];
		$zapUrls = array();

		if (self::$options['zapier_individual_cus'] && $meta['zapier_individual_webhook_url']) {
			$zapUrls[] = $meta['zapier_individual_webhook_url'];
		}
		if (self::$options['zapier_webhook_url']) {
			$zapUrls[]= self::$options['zapier_webhook_url'];
		}

		if (count($zapUrls)) {
			foreach ($zapUrls as $zapUrl) {
				$json = json_encode(array(
					'email'					=> $email,
					'first_name'			=> $firstname,
					'content_upgrade_title'	=> $cuTitle
				));
				self::log( 'Posting to url: ' . $zapUrl . ' data: ' . $json );
				$headers = array();
				$formData = array( 'sslverify' => false, 'ssl' => true, 'body' => $json, 'headers' => $headers );
				$response = wp_remote_post( $zapUrl, $formData );

				if ( is_wp_error( $response ) ) {
					self::log( 'The following error occurred while posting to Zapier: ' . print_r( $response, true ) );
				} else {
					self::log( 'Successful response from Zapier: ' . print_r( $response, true ) );
				}
			}
		}
	}

}
